#!/usr/bin/env python
# -*- coding: utf-8 -*- 
# Hello World in GIMP Python
# http://www.efalk.org/Docs/Python/gimp-examples.html więcej szczegółów

from gimpfu import *  # Importujemy niezbędne moduły (odpowiednią bibliotekę), 
# aby skrypt wiedział, z których wbudowanych funkcji ma korzystać.

def hello_world(initstr, font, size, color) :
    # Najpierw robimy szybki test poprawności czcionki
    if font == 'Comic Sans MS' :
        initstr = "Comic Sans? Are you sure?"

    # Tworzymy nowy obraz. Tymczasowo o rozmiarze 10x10 -- rozmiar będzie późnej zmieniany.
    img = gimp.Image(10, 10, RGB)

    # Zapisujemy aktualny kolor pierwszoplanowy, aby móc z niego skorzystać potem:
    pdb.gimp_context_push()

    # Ustawiamy kolor czcionki (tekstu) na ten, który przekazujemy do funkcji
    gimp.set_foreground(color)

    # Teraz można przejść do tworzenia nowej warstwy, gdzie będzie się znajdował tekst. 
	# Pamiętamy cały czas o tym, że warstwa jest obiektem, więc trzeba ten obiekt 
	# przypisać do zmiennej, będzie - layer.
    layer = pdb.gimp_text_fontname(img, None, 0, 0, initstr, 10,
                                   True, size, PIXELS, font)

    # Musimy zmienić rozmiar obiektu, na którym warstwa została umieszczona, 
	# aby były takie same (zmiana rozmiaru obrazu do rozmiaru warstwy). 
	# Do tego możemy skorzystać z atrybutów warstwy, takich, jak: layer.weigth oraz layer.height.
    img.resize(layer.width, layer.height, 0, 0)

    # Dodajemy warstwę Tło, które zawsze będzie przeźroczyste, jeżeli będziemy pracowali na obiekcie Image
	# i nie nadamy mu tła). Dlatego odrazu dodamy kolor.
    # (Nie można było dodać tego najpierw, ponieważ nie znano, wielkość warstwy tekstowej.)
    background = gimp.Layer(img, "Background", layer.width, layer.height,
                            RGB_IMAGE, 100, NORMAL_MODE)
    background.fill(BACKGROUND_FILL)
    img.add_layer(background, 1)

    # Jak na razie na ekranie nadal nic nie będzie, bo żaden obiekt nie został wywołany. 
	# Musimy zatem "uworzyć nowe okno obrazu na ekranie" wszystkie utworzone obiekty, 
	# czyli ten główny, na którym cały czas pracowaliśmy
    gimp.Display(img)
    # Aktualizujemy obraz na wyświetlaczu
    gimp.displays_flush()

    # Przywracamy "stary" kolor pierwszego planu:
    pdb.gimp_context_pop()



register(
    "hello_world",
    "Obraz Hello world ", 
    "Tworzymy nowy obraz z Naszego łańcucha tekstu",
    "Akkana Peck, Modified: Zbyma72age",
    "Akkana Peck",
    "2010",
    "_Hello world (Py)...", # Etykieta, nazwa punktu w menu, za pomocą której, wtyczka będzie uruchamiana, 
		# zastosowanie znaku podkreślenia "_" przed pierwszym znakiem powinno spowodować, że możemy używać 
		# skrótu klawiaturowego, wygoda jeżeli w Katalogu/podkatalogu znajduje sie więcej wtyczek. Klikamy na katalog i potem skrót. 
    "",      # Tworzenie nowego obrazu, nie działa na istniejącym
    [
        (PF_STRING, "string", "Napis", 'Hello, world!'),
        (PF_FONT, "font", "Wybór czcionki", "Sans"),
        (PF_SPINNER, "size", "Rozmiar czcionki", 50, (1, 3000, 1)),
        (PF_COLOR, "color", "Kolor tekstu", (1.0, 0.0, 0.0))
    ],
    [],
    hello_world, menu="<Image>/File/Create") 

main()
